/*
 * graphic_transform.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "colour_change.hpp"
#include "gfx_resizer.hpp"
#include "graphic_transform.hpp"
#include "round.hpp"

boost::shared_ptr<const Coercri::PixelArray> CreateGraphicWithCC(boost::shared_ptr<const Coercri::PixelArray> pixels,
                                                          const ColourChange &cc)
{
    const int width = pixels->getWidth();
    const int height = pixels->getHeight();
    boost::shared_ptr<Coercri::PixelArray> new_pixels(new Coercri::PixelArray(width, height));

    for (int y = 0; y < height; ++y) {
        for (int x = 0; x < width; ++x) {
            const Coercri::Color &in = (*pixels)(x,y);
            Colour result;
            Coercri::Color &out = (*new_pixels)(x,y);
            if (cc.lookup(Colour(in.r, in.g, in.b, in.a), result)) {
                out.r = result.r;
                out.g = result.g;
                out.b = result.b;
                out.a = result.a;
            } else {
                out = in;
            }
        }
    }

    return new_pixels;
}

boost::shared_ptr<const Coercri::PixelArray> CreateResizedGraphic(const GfxResizer &resizer,
                                                           boost::shared_ptr<const Coercri::PixelArray> original,
                                                           int new_width, int new_height,
                                                           int old_hx, int old_hy, int &new_hx, int &new_hy)
{
    const int old_width = original->getWidth();
    const float scale = float(new_width) / float(old_width);
    new_hx = Round(float(old_hx) * scale);
    new_hy = Round(float(old_hy) * scale);
    return resizer.resize(original, new_width, new_height);
}
