/*
 * gfx_resizer_scale2x.hpp
 *
 * GfxResizerScale2x: Uses the Scale2x and/or Scale3x algorithms developed by Andrea Mazzoleni.
 * See http://scale2x.sourceforge.net/ for details.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef GFX_RESIZER_SCALE2X
#define GFX_RESIZER_SCALE2X

#include "gfx_resizer.hpp"

class GfxResizerScale2x : public GfxResizer {
public:
    explicit GfxResizerScale2x(int mx = -1) : max_scale(mx) { }  // -1 = unrestricted

    virtual void roundScaleFactor(float ideal, float &rounded_down, float &rounded_up) const;

    virtual boost::shared_ptr<const Coercri::PixelArray> resize(boost::shared_ptr<const Coercri::PixelArray> original,
                                                                int new_width, int new_height) const;
private:
    int max_scale;
};

#endif
