/*
 * gfx_resizer_compose.hpp
 *
 * GfxResizerCompose: composes two GfxResizers, useful e.g. for running
 * Scale2x followed by a nearest-nbr or bilinear pass.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef GFX_RESIZER_COMPOSE
#define GFX_RESIZER_COMPOSE

#include "gfx_resizer.hpp"

class GfxResizerCompose : public GfxResizer {
public:
    // NOTE: Can set right=NULL, cannot set left=NULL though.
    GfxResizerCompose(boost::shared_ptr<GfxResizer> left_, boost::shared_ptr<GfxResizer> right_, bool lock_to_int_)
        : left(left_), right(right_), lock_to_int(lock_to_int_) { }

    virtual void roundScaleFactor(float ideal_scale_factor, float &rounded_down, float &rounded_up) const;

    virtual boost::shared_ptr<const Coercri::PixelArray> resize(boost::shared_ptr<const Coercri::PixelArray> original,
                                                                int new_width, int new_height) const;

private:
    float intermedScaleFactor(float ideal_scale_factor) const;
    
    boost::shared_ptr<GfxResizer> left, right;
    bool lock_to_int;
};

#endif
