/*
 * gfx_resizer.hpp
 *
 * GfxResizer: Interface for working out "resized rectangles". This
 * allows the display to adapt if the window is resized by the user.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef GFX_RESIZER_HPP
#define GFX_RESIZER_HPP

#include "gfx/pixel_array.hpp"   // coercri

#include "boost/shared_ptr.hpp"

class GfxResizer {
public:
    virtual ~GfxResizer() { }

    // Rounds the scale factor to a value acceptable to the resizer.
    // Post-condition: either rounded_down <= ideal_scale_factor <= rounded_up,
    // or rounded_down == rounded_up < ideal_scale_factor,
    // or ideal_scale_factor < rounded_down == rounded_up
    // (the latter two cases occur if the ideal_scale_factor is out of range for this resizer).

    // NOTE: At the moment we have a restriction that this always returns integer factors, OR
    // is completely unrestricted (because of the way getResizedRectangle works; see display.cpp)
    
    virtual void roundScaleFactor(float ideal_scale_factor, float &rounded_down, float &rounded_up) const
    {
        rounded_down = rounded_up = ideal_scale_factor;
    }
    
    // Resize a PixelArray
    virtual boost::shared_ptr<const Coercri::PixelArray> resize(boost::shared_ptr<const Coercri::PixelArray> original, 
                                                                int new_width, int new_height) const = 0;
};

#endif

                                     
