/*
 * find_server_screen.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#ifndef FIND_SERVER_SCREEN_HPP
#define FIND_SERVER_SCREEN_HPP

#include "screen.hpp"

#include <string>

class FindServerScreenImpl;

class FindServerScreen : public Screen {
public:
    FindServerScreen(const std::string &title, bool internet);
    virtual bool start(KnightsApp &knights_app, boost::shared_ptr<Coercri::Window> window, gcn::Gui &gui);
    virtual void update();
    virtual unsigned int getUpdateInterval();

private:
    boost::shared_ptr<FindServerScreenImpl> pimpl;
    std::string title;
    bool internet;
};

#endif

