/*
 * error_screen.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef ERROR_SCREEN_HPP
#define ERROR_SCREEN_HPP

#include "screen.hpp"

#include <string>

class ErrorScreenImpl;

class ErrorScreen : public Screen {
public:
    explicit ErrorScreen(const std::string &msg_) : msg(msg_) { }
    virtual bool start(KnightsApp &app, boost::shared_ptr<Coercri::Window> win, gcn::Gui &gui);

private:
    boost::shared_ptr<ErrorScreenImpl> pimpl;
    std::string msg;
};

#endif
