/*
 * error_screen.cpp
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "knights_app.hpp"

#include "error_screen.hpp"
#include "title_screen.hpp"

#include "gui_button.hpp"
#include "gui_centre.hpp"
#include "gui_panel.hpp"

#include "boost/scoped_ptr.hpp"
using namespace boost;

class ErrorScreenImpl : public gcn::ActionListener {
public:
    ErrorScreenImpl(KnightsApp &app, gcn::Gui &gui, const std::string &msg)
        : knights_app(app)
    {
        // create container
        container.reset(new gcn::Container);
        container->setOpaque(false);

        int y = 6;
        const int hpad = 6, vpad = 6;
        
        // create label
        label.reset(new gcn::Label(msg));
        container->add(label.get(), hpad, y);
        y += label->getHeight() + vpad;
        
        // create exit button
        exit_button.reset(new GuiButton("Exit"));
        exit_button->addActionListener(this);
        container->add(exit_button.get(), hpad + label->getWidth()/2 - exit_button->getWidth()/2, y);
        y += exit_button->getHeight() + vpad;

        // resize the container
        container->setSize(label->getWidth() + 2*hpad, y);

        // add panel, centre.
        panel.reset(new GuiPanel(container.get()));
        centre.reset(new GuiCentre(panel.get()));
        gui.setTop(centre.get());
    }

    void action(const gcn::ActionEvent &event)
    {
        auto_ptr<Screen> title_screen(new TitleScreen);
        knights_app.requestScreenChange(title_screen);
    }

private:
    KnightsApp &knights_app;
    scoped_ptr<GuiCentre> centre;
    scoped_ptr<GuiPanel> panel;
    scoped_ptr<gcn::Container> container;
    scoped_ptr<gcn::Label> label;
    scoped_ptr<gcn::Button> exit_button;
};

bool ErrorScreen::start(KnightsApp &app, shared_ptr<Coercri::Window>, gcn::Gui &gui)
{
    app.resetAll();
    pimpl.reset(new ErrorScreenImpl(app, gui, msg));
    return true;
}
