/*
 * draw.hpp
 *
 * Contains code for drawing various bits of the in-game displays.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef DRAW_HPP
#define DRAW_HPP

#include "graphic_element.hpp"
#include "map_support.hpp"

// coercri
#include "gfx/font.hpp"
#include "gfx/gfx_context.hpp"
#include "gfx/graphic.hpp"

#include "boost/shared_ptr.hpp"

#include <map>
#include <vector>
using namespace std;

class ColourChange;
class ConfigMap;
class Creature;
class DungeonMap;
class Entity;
class GfxManager;
class MapCoord;


class DrawUI {
public:
    // Draw backpack entries (items).
    // This is called once per backpack 'slot' (i.e. item type).
    static void drawBackpackEntry(Coercri::GfxContext &gc, int x, int y, int width, int height,
                                  GfxManager &gm, int num_slots, int spacing, int gem_height,
                                  int slot, const Graphic *gfx, const Graphic *overdraw,
                                  int no_carried, int no_max);
    
    // Draw a text message over a certain square
    // d_left, d_top, d_width, d_height give the dungeon rectangle
    // Sq_rel_x and Sq_rel_y give the square position
    // W and H give the room dimensions (in squares)
    // Message is the text to be displayed.
    static void drawMessage(const ConfigMap &config_map,
                            Coercri::GfxContext &gc, int d_left, int d_top, int d_width, int d_height,
                            GfxManager &gm, int sq_rel_x, int sq_rel_y,
                            int w, int h, int pixels_per_square, const string &message);

    
    // Draw the menu
    static void drawMenu(const ConfigMap &config_map, 
                         Coercri::GfxContext &gc, int left, int top, int width, int height,
                         GfxManager &gm, 
                         const Graphic * gfx_centre, const Graphic * gfx_empty,
                         const Graphic * gfx_highlight, int time,
                         const Graphic * gfx_north, const Graphic * gfx_east,
                         const Graphic * gfx_south, const Graphic * gfx_west,
                         bool highlight, MapDirection highlight_dir);

private:
    static void drawMenuItem(Coercri::GfxContext &, GfxManager &gm,
                             const Graphic *, const Graphic *,
                             int, int, int, int);
};

#endif
