/*
 * credits_screen.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "credits_screen.hpp"
#include "gui_text_wrap.hpp"
#include "knights_app.hpp"
#include "rstream.hpp"
#include "title_screen.hpp"

// coercri
#include "gcn/cg_font.hpp"

#include "guichan.hpp"

#include "boost/scoped_ptr.hpp"
using namespace boost;

class CreditsScreenImpl : public gcn::ActionListener, public gcn::WidgetListener {
public:
    explicit CreditsScreenImpl(KnightsApp &kg, gcn::Gui &gui);
    void action(const gcn::ActionEvent &event);
    void widgetResized(const gcn::Event &event);
    
private:
    KnightsApp &knights_app;
    scoped_ptr<GuiTextWrap> text_wrap;
    scoped_ptr<gcn::Font> white_font;
    scoped_ptr<gcn::ScrollArea> scroll_area;
};

CreditsScreenImpl::CreditsScreenImpl(KnightsApp &app, gcn::Gui &gui)
    : knights_app(app)
{
    RStream str("credits.txt");
    std::string credits;
    while (str) {
        char c = 0;
        str.get(c);
        credits += c;
    }
    
    white_font.reset(new Coercri::CGFont(app.getFont(), Coercri::Color(255,255,255)));
    text_wrap.reset(new GuiTextWrap);
    text_wrap->setFont(white_font.get());
    text_wrap->setRich(true);
    text_wrap->setText(credits);
    text_wrap->addActionListener(this);
    
    scroll_area.reset(new gcn::ScrollArea);
    scroll_area->setContent(text_wrap.get());
    scroll_area->addWidgetListener(this);
    scroll_area->setBackgroundColor(gcn::Color(0,0,0));
    scroll_area->setOpaque(true);
    scroll_area->setScrollbarWidth(16);
    gui.setTop(scroll_area.get());
}

void CreditsScreenImpl::action(const gcn::ActionEvent &event)
{
    auto_ptr<Screen> scr(new TitleScreen);
    knights_app.requestScreenChange(scr);
}

void CreditsScreenImpl::widgetResized(const gcn::Event &event)
{
    text_wrap->setWidth(std::max(0, scroll_area->getWidth() - scroll_area->getScrollbarWidth()));
    text_wrap->adjustHeight();
    scroll_area->logic();
}

bool CreditsScreen::start(KnightsApp &knights_app, shared_ptr<Coercri::Window> w, gcn::Gui &gui)
{
    pimpl.reset(new CreditsScreenImpl(knights_app, gui));
    return true;
}
