/*
 * controller.hpp
 *
 * "Controllers" act as an interface between the LocalDungeonView (in
 * particular, LocalDungeonView::getStick) and the input device
 * itself.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef CONTROLLER_HPP
#define CONTROLLER_HPP

#include "map_support.hpp"

#include "gfx/key_code.hpp"

#include <vector>

class Controller {
public:
    virtual ~Controller() { }

    // Controllers have up/down/left/right, fire and suicide.
    virtual void get(MapDirection &dir, bool &centred, bool &fire_held,
                     bool &suicide_held) const = 0;

    // "reserved" keys cannot be used in the gui chat box.
    virtual std::vector<Coercri::KeyCode> getReservedKeys() const {
        return std::vector<Coercri::KeyCode>();
    }
};

#endif
