/*
 * connecting_screen.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#ifndef CONNECTING_SCREEN_HPP
#define CONNECTING_SCREEN_HPP

#include "screen.hpp"

#include "boost/shared_ptr.hpp"
#include <string>

class ConnectingScreenImpl;

class ConnectingScreen : public Screen {
public:
    ConnectingScreen(const std::string &address, int port, bool join_lan_game, const std::string &player_name);
    virtual bool start(KnightsApp &knights_app, boost::shared_ptr<Coercri::Window> window, gcn::Gui &gui);
    virtual void update();
    virtual unsigned int getUpdateInterval() { return 50; }
private:
    boost::shared_ptr<ConnectingScreenImpl> pimpl;
};

#endif
