/*
 * adjust_list_box_size.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "adjust_list_box_size.hpp"

void AdjustListBoxSize(gcn::ListBox &listbox, gcn::ScrollArea &scrollarea)
{
    gcn::ListModel *model = listbox.getListModel();
    gcn::Font *font = listbox.getFont();
    if (!model || !font) return;
    
    listbox.adjustSize();  // adjusts the vertical size only.

    // work out min width for the listbox. this depends on whether the
    // vertical scrollbar is being shown or not.
    const bool scrollbar_shown = listbox.getHeight() > scrollarea.getHeight();
    int width = scrollarea.getWidth();
    if (scrollbar_shown) width -= scrollarea.getScrollbarWidth();
    
    // compute the horizontal size as the max of horiz sizes of each row.
    const int nels = model->getNumberOfElements();
    for (int i = 0; i < nels; ++i) {
        width = std::max(width, font->getWidth(model->getElementAt(i)));
    }

    listbox.setWidth(width);
}
