/*
 * random_int.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "random_int.hpp"

int KConfig::RIDice::get() const
{
	int x = 0;
	for (int i=0; i<n; ++i) {
		x += GetRandom(d) + 1;
	}
	return x;
}

int KConfig::RIList::get() const
{
	using std::vector;
	using std::pair;
	int w = GetRandom(total_weight);
	for (vector<pair<const RandomInt*, int> >::const_iterator it = contents.begin(); it != contents.end(); ++it) {
		w -= it->second;
		if (w < 0) {
			return it->first->get();
		}
	}
	ASSERT(0);
	return 0;
}

