/*
 * menu_constraints.hpp
 *
 * Implements constraints on menu settings.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MENU_CONSTRAINTS_HPP
#define MENU_CONSTRAINTS_HPP

#include "boost/shared_ptr.hpp"

#include <string>
#include <vector>

class KnightsConfigImpl;
class Menu;
class MenuConstraint;  // implementation class
class MenuSelections;

class MenuConstraints {
public:
    // update menu selections to be consistent with constraints.
    // also update 'allowed settings'.
    void apply(const Menu &menu, MenuSelections &msel) const;
    
    // construction
    void addConstraintFromKFile(const std::string &key, int val, const std::string &dname, KnightsConfigImpl &kc);

private:
    std::vector<boost::shared_ptr<MenuConstraint> > constraints;
};

#endif
