/*
 * knights_engine.hpp
 *
 * This is the main class that runs a single game of Knights.
 *
 * NOTE: There is a limitation that only one instance of KnightsEngine
 * can be created per thread at the moment. This is because of the way
 * my Mediator class works.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef KNIGHTS_ENGINE_HPP
#define KNIGHTS_ENGINE_HPP

#include "boost/shared_ptr.hpp"

class KnightsCallbacks;
class KnightsConfig;
class KnightsEngineImpl;
class MenuSelections;
class UserControl;

class KnightsEngine {
public:
    // Start up a new KnightsEngine. Requires KnightsConfig and menu settings.
    // Note that the same KnightsConfig can be re-used between different KnightsEngines.
    KnightsEngine(boost::shared_ptr<const KnightsConfig> config,
                  const MenuSelections &msel,
                  int house_col_0, int house_col_1);
    ~KnightsEngine();

    // Run one update step (for a given time).
    // Uses KnightsCallbacks to inform caller of what happened during the update.
    void update(int time_delta, KnightsCallbacks &callbacks);

    // Input cmds that might be received from players.
    void setControl(int player, const UserControl *control);

private:
    boost::shared_ptr<KnightsEngineImpl> pimpl;
};

#endif
