/*
 * trap.hpp
 *
 * Trap: Base class for trap implementations (ie poison or blade traps).
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TRAP_HPP
#define TRAP_HPP

#include "boost/shared_ptr.hpp"
using namespace boost;

class Creature;
class DungeonMap;
class ItemType;
class MapCoord;

class Trap {
public:
    explicit Trap(const ItemType *it) : trap_item(it) { }
    virtual ~Trap() { }
    const ItemType *getTrapItem() const { return trap_item; }
    virtual void spring(DungeonMap &, const MapCoord &, shared_ptr<Creature>) = 0;
    virtual bool activateOnHit() const = 0;
private:
    const ItemType *trap_item;
};

#endif
