/*
 * teleport.hpp
 *
 * Routines to implement teleportation.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TELEPORT_HPP
#define TELEPORT_HPP

#include "boost/shared_ptr.hpp"
using namespace boost;

class Entity;
class Knight;

// Teleport an entity directly to a given square
// If the square is occupied, try nearby alternative squares.
// Returns true if successful.
bool TeleportToSquare(shared_ptr<Entity> from, DungeonMap &dmap, const MapCoord &mc);

// Teleport an entity into the same room as some target entity.
void TeleportToRoom(shared_ptr<Entity> from, shared_ptr<Entity> to);

// Find the nearest other knight. (Used to determine teleport
// sources or destinations.)
shared_ptr<Knight> FindNearestOtherKnight(const DungeonMap &, const MapCoord &);

#endif
