/*
 * task_manager.hpp
 *
 * NB don't put the same task in 2 different taskmanagers, or add the same task twice to a taskmanager ....
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TASK_MANAGER_HPP
#define TASK_MANAGER_HPP

#include "task.hpp"   // for CompareTime, TaskPri

#include "boost/shared_ptr.hpp"
#include <functional>
#include <set>

class CompareTime : public std::binary_function<const boost::shared_ptr<Task>&,
                                                const boost::shared_ptr<Task>&, bool> {
public:
    bool operator()(const boost::shared_ptr<Task> &lhs, const boost::shared_ptr<Task> &rhs) const {
        return lhs->time < rhs->time;
    }
};

class TaskManager {
public:
    TaskManager() : gvt(0) { }
    
    void addTask(boost::shared_ptr<Task> t, TaskPri pri, int exec_time);
    void changeTaskPri(boost::shared_ptr<Task> t, TaskPri new_pri);
    void changeExecTime(boost::shared_ptr<Task> t, int new_exec_time);
    void rmTask(boost::shared_ptr<Task> t);  // does nothing if t not found in the taskmanager
    void rmAllTasks();
    
    // This increases time then runs tasks as they become ready.
    void advanceToTime(int target_time);

    // For information
    int getGVT() const { return gvt; }
    
private:
    int gvt;
    typedef std::multiset<boost::shared_ptr<Task>, CompareTime > QueueType;
    enum { NUM_QUEUES = 2 };
    QueueType task_queue[NUM_QUEUES];

    QueueType::iterator findTask(boost::shared_ptr<Task>);
};

#endif
