/*
 * task.hpp
 *
 * Task: something to be run at a certain point in the future.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TASK_HPP
#define TASK_HPP

#include "boost/enable_shared_from_this.hpp"
using namespace boost;

class TaskManager;

enum TaskPri { TP_LOW, TP_NORMAL };

class Task : public enable_shared_from_this<Task> {
    friend class TaskManager;
    friend class CompareTime;
public:
    Task() : time(-1) { }
    virtual ~Task() { }

    // tasks are removed from the TaskManager before execution. They should be re-added (using
    // addTask) if re-execution is desired. (A reference to the TaskManager is passed in
    // to execute().)
    // Note: the TaskManager will hold a shared_ptr to the Task during the execute() call;
    // the task is therefore guaranteed not to be deleted during execute().
    virtual void execute(TaskManager &) = 0;

    // find (absolute) time that we will run next.
    // returns negative value if not currently inserted into a task manager, or during
    // execute().
    int getExecTime() const { return time; }

private:
    TaskPri pri;
    int time;  // time of next run. (this is always -ve if task not currently scheduled.)
};

#endif
