/*
 * sweep.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SWEEP_HPP
#define SWEEP_HPP

#include "map_support.hpp"

// SweepCreatures moves any creatures that need to be moved, according to
// the new access level.
// If "use_height" is true then restrict to creatures at the given height only. (If
// "use_height" is false then pass in a dummy value for ht, eg H_MISSILES.)
void SweepCreatures(DungeonMap &dmap, const MapCoord &mc, bool use_height, MapHeight ht);

// SweepItems moves aside any item at mc (or destroys it if it can't
// be moved). Called when items-allowed becomes FALSE.
void SweepItems(DungeonMap &dmap, const MapCoord &mc);

#endif
