/*
 * segment_set.hpp
 *
 * SegmentSet: collection of Segments.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef SEGMENT_SET_HPP
#define SEGMENT_SET_HPP

class Segment;

#include "boost/noncopyable.hpp"

#include <vector>
using namespace std;

class SegmentSet : boost::noncopyable {
public:
    ~SegmentSet();  // deletes all contained segments.
    
    void addSegment(const Segment *, int nhomes, int category = -1);
    
    const Segment * getHomeSegment(int minhomes) const;
    const Segment * getSpecialSegment(int category) const;
    
private:
    vector<vector<const Segment *> > segments;    // segments[nhomes][segmentno].
    vector<vector<const Segment *> > special_segments;  // special_segments[category][segmentno].
};

#endif
