/*
 * segment_set.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "rng.hpp"
#include "segment.hpp"
#include "segment_set.hpp"

SegmentSet::~SegmentSet()
{
    // delete all contained segments
    for (vector<vector<const Segment *> >::iterator it1 = segments.begin(); it1 != segments.end(); ++it1) {
        for (vector<const Segment *>::iterator it2 = it1->begin(); it2 != it1->end(); ++it2) {
            delete *it2;
        }
    }
    for (vector<vector<const Segment *> >::iterator it1 = special_segments.begin(); it1 != special_segments.end(); ++it1) {
        for (vector<const Segment *>::iterator it2 = it1->begin(); it2 != it1->end(); ++it2) {
            delete *it2;
        }
    }
}

void SegmentSet::addSegment(const Segment *r, int nhomes, int category)
{
    if (nhomes < 0) return;
    if (category < 0) {
        if (segments.size() < nhomes+1) segments.resize(nhomes+1);
        segments[nhomes].push_back(r);
    } else {
        if (special_segments.size() < category+1) special_segments.resize(category+1);
        special_segments[category].push_back(r);
    }
}

const Segment * SegmentSet::getHomeSegment(int minhomes) const
{
    int nsets = segments.size();
    if (minhomes >= nsets) return 0;
    if (minhomes < 0) minhomes = 0;

    int nsegments = 0;
    for (int i=minhomes; i<nsets; ++i) nsegments += segments[i].size();

    int r = g_rng.getInt(0, nsegments);
    for (int i=minhomes; i<nsets; ++i) {
        if (r < segments[i].size()) {
            return segments[i][r];
        } else {
            r -= segments[i].size();
        }
    }
    
    ASSERT(0);
    return 0;
}

const Segment * SegmentSet::getSpecialSegment(int category) const
{
    if (category < 0 || category >= special_segments.size()) return 0;
    int r = g_rng.getInt(0, special_segments[category].size());
    return special_segments[category][r];
}
