/*
 * room_map.hpp
 *
 * "Rooms" are stored as rectangles with a top-left corner position
 * and a width and height. The definition of the room includes its
 * border (but NOT the four corner squares), therefore rooms overlap
 * each other by one square around the edges. Each square in the
 * dungeon is part of either zero, one or two rooms.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef ROOM_MAP_HPP
#define ROOM_MAP_HPP

#include "map_support.hpp"

#include <vector>
using namespace std;

class RoomMap {
public:
    // construction
    RoomMap();
    void addRoom(const MapCoord &top_left, int w, int h);
    void doneAddingRooms();  // call once all rooms are added.

    // "getRoomAtPos" returns the room(s) associated with a square. If
    // it's a border square, 2 room numbers are returned. If it's an
    // interior square, one room number will be returned, and r2 will
    // be set to -1. (Otherwise both r1 and r2 will be set to -1.)
    void getRoomAtPos(const MapCoord &mc, int &r1, int &r2) const;

    // "isCorner" checks whether the square is one of the four corners
    // of some room.
    bool isCorner(const MapCoord &mc) const;
    
    // "inSameRoom" checks whether two given mapcoords are in the same room.
    bool inSameRoom(const MapCoord &mc1, const MapCoord &mc2) const;

    // "getRoomLocation" looks up the pos & size of a numbered room.
    void getRoomLocation(int r, MapCoord &top_left, int &w, int &h) const;
        
private:
    struct RoomInfo {
        MapCoord pos;
        int w, h;
    };
    vector<RoomInfo> rooms;
    bool ready; // set once "doneAddingRooms" has been called.
};

#endif
