/*
 * quest.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef QUEST_HPP
#define QUEST_HPP

#include "status_display.hpp"

#include <string>
#include <vector>
using namespace std;

class ItemType;
class Knight;

class Quest {
public:
    virtual ~Quest() { }

    // Check is called in two circumstances:
    // (i)  The knight has just whacked the special pentagram square. (See A_CheckQuest.)
    // (ii) The knight has just approached his own exit point. (See A_HomeStart.)
    virtual bool check(Knight &kt) const = 0;

    // getHint() is called when we approach the exit point but check() returns false.
    // The hint text is flashed up onto the screen.
    virtual string getHint() const { return string(); }

    // determine whether this quest is interested in a certain item type
    // (used for "Sense Items").
    virtual bool isItemInteresting(const ItemType &) const = 0;

    // This appends a QuestIconInfo for this quest (if applicable).
    // The num_held will be set to zero if a Knight is not supplied.
    virtual void appendQuestIcon(const Knight *kt, std::vector<StatusDisplay::QuestIconInfo> &icons) const = 0;

    // returns msg describing this quest, or blank
    // currently only used for "Destroy Book with Wand"
    virtual std::string getQuestMessage() const { return ""; }
};

#endif
