/*
 * monster_type.hpp
 *
 * Represents a "type" of monster.
 * Responsible for creating new monsters of that type, and for starting off monster AI.
 * 
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MONSTER_TYPE_HPP
#define MONSTER_TYPE_HPP

class Monster;
class MonsterManager;
class TaskManager;

#include "boost/shared_ptr.hpp"
using namespace boost;

class MonsterType {
public:
    virtual ~MonsterType() { }

    // makeMonster should both return a new monster object, and start off an AI task.
    virtual shared_ptr<Monster> makeMonster(MonsterManager &mm, TaskManager &tm) const = 0;

    // at which height will this monster be generated?
    virtual MapHeight getHeight() const = 0;
};


#endif
