/*
 * monster_task.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "knight.hpp"
#include "mediator.hpp"
#include "monster_manager.hpp"
#include "monster_task.hpp"
#include "player.hpp"
#include "task_manager.hpp"

void MonsterTask::execute(TaskManager &tm)
{
    Mediator &mediator = Mediator::instance();
    const int radius = mediator.cfgInt("monster_radius");
    const int interval = mediator.cfgInt("monster_interval");
    
    int left = 999999, right = 0,
        bottom = 999999, top = 0;
    Mediator &med(mediator);
    for (vector<Player*>::const_iterator it = med.getPlayers().begin();
    it != med.getPlayers().end(); ++it) {
        shared_ptr<Knight> kt = (*it)->getKnight();
        if (kt && kt->getMap()) {
            const int x = kt->getPos().getX();
            if (x-radius < left) left = x-radius;
            if (x+1+radius > right) right = x+1+radius;
            const int y = kt->getPos().getY();
            if (y-radius < bottom) bottom = y-radius;
            if (y+1+radius > top) top = y+1+radius;
        }
    }
    med.getMonsterManager().doMonsterGeneration(*med.getMap(), left, bottom, right, top);

    tm.addTask(shared_from_this(), TP_LOW, tm.getGVT() + interval);
}
