/*
 * monster_support.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "dungeon_map.hpp"
#include "monster_support.hpp"

bool KnightAt(DungeonMap &dmap, const MapCoord &mc, const ItemType *fear)
{
    vector<shared_ptr<Entity> > ents;
    dmap.getEntities(mc, ents);
    for (vector<shared_ptr<Entity> >::iterator it = ents.begin(); it != ents.end(); ++it) {
        Knight * kt = dynamic_cast<Knight*>(it->get());
        if (kt && (!fear || kt->getItemInHand() != fear)) {
            return true;
        }
    }
    return false;
}


MapDirection DirectionFromTo(const MapCoord &from, const MapCoord &to)
{
    int dx = to.getX() - from.getX();
    int dy = to.getY() - from.getY();
    if (abs(dx) > abs(dy)) {
        if (dx > 0) return D_EAST;
        else return D_WEST;
    } else {
        if (dy > 0) return D_SOUTH;
        else return D_NORTH;
    }
}
