/*
 * monster.hpp
 *
 * The Monster class includes code in the onDeath routine to place
 * a monster corpse into the map.
 *
 * A pointer to the MonsterType is also stored.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MONSTER_HPP
#define MONSTER_HPP

#include "creature.hpp"

class MonsterManager;
class MonsterType;

class Monster : public Creature {
public:
    Monster(MonsterManager &mmgr, const MonsterType &type_, int health, MapHeight ht,
            const ItemType *item_in_hand, const Anim *anim, int speed)
        : Creature(health, ht, item_in_hand, anim, speed),
          monster_manager(mmgr), type(type_) { }

    virtual ~Monster();
    virtual void onDeath(DeathMode dmode);

private:
    MonsterManager &monster_manager;
    const MonsterType &type;
};

#endif
