/*
 * monster.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "mediator.hpp"
#include "monster.hpp"
#include "monster_manager.hpp"

Monster::~Monster()
{
    monster_manager.subtractMonster(type);
}

void Monster::onDeath(DeathMode dmode)
{
    // We use this routine to place the monster corpse.
    if (!getMap()) return;
    if (dmode != PIT_MODE && dmode != ZOMBIE_MODE) {
        Mediator::instance().placeMonsterCorpse(*getMap(), getNearestPos(), type);
    }
}
