/*
 * missile.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MISSILE_HPP
#define MISSILE_HPP

#include "entity.hpp"
#include "map_support.hpp"

class ItemType;


// Add a new missile to the map. "Drop_after" controls whether an item
// should be dropped after the missile hits (true for axes, daggers
// etc, but false for skulls). "With_strength" doubles the range.
// Returns true if the missile was successfully created.
bool CreateMissile(DungeonMap &dmap, const MapCoord &mc, MapDirection dir, 
                   const ItemType &it, bool drop_after, bool with_strength);

// The Missile class itself
class Missile : public Entity {
    friend class MissileTask;
public:
    Missile(const ItemType &it, bool da);
    virtual MapHeight getHeight() const;
    void doubleRange() { range_left *= 2; } // used for strength
private:
    const ItemType &itype;
    int range_left;
    bool drop_after;
};

#endif
