/*
 * menu_int.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef MENU_INT_HPP
#define MENU_INT_HPP

#include "menu_selections.hpp"

class MenuInt {
public:
    virtual ~MenuInt() { }
    virtual int getValue(const MenuSelections &msel) const = 0;
};

class MenuIntConst : public MenuInt {
public:
    explicit MenuIntConst(int xx) : x(xx) { }
    virtual int getValue(const MenuSelections &) const { return x; }
private:
    int x;
};

class MenuIntVar : public MenuInt {
public:
    explicit MenuIntVar(const std::string &key_) : key(key_) { }
    virtual int getValue(const MenuSelections &msel) const { return msel.getValue(key); }
private:
    std::string key;
};

#endif
