/*
 * knights_config.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "knights_config.hpp"
#include "knights_config_impl.hpp"

//
// constructor
//

KnightsConfig::KnightsConfig(const std::string &config_filename)
    : pimpl(new KnightsConfigImpl(config_filename))
{ }

void KnightsConfig::getAnims(std::vector<const Anim*> &anims) const
{
    pimpl->getAnims(anims);
}

void KnightsConfig::getGraphics(std::vector<const Graphic*> &graphics) const
{
    pimpl->getGraphics(graphics);
}

void KnightsConfig::getOverlays(std::vector<const Overlay*> &overlays) const
{
    pimpl->getOverlays(overlays);
}

void KnightsConfig::getSounds(std::vector<const Sound*> &sounds) const
{
    pimpl->getSounds(sounds);
}

void KnightsConfig::getStandardControls(std::vector<const UserControl*> &controls) const
{
    pimpl->getStandardControls(controls);
}

void KnightsConfig::getOtherControls(std::vector<const UserControl*> &controls) const
{
    pimpl->getOtherControls(controls);
}

const Menu & KnightsConfig::getMenu() const
{
    return pimpl->getMenu();
}

const MenuConstraints & KnightsConfig::getMenuConstraints() const
{
    return pimpl->getMenuConstraints();
}

int KnightsConfig::getApproachOffset() const
{
    return pimpl->getApproachOffset();
}

void KnightsConfig::getHouseColours(std::vector<Coercri::Color> &result) const
{
    pimpl->getHouseColours(result);
}

std::string KnightsConfig::getQuestDescription(int quest_num) const
{
    return pimpl->getQuestDescription(quest_num);
}


//
// interface used by KnightsEngine
//

void KnightsConfig::initializeGame(const MenuSelections &msel,
                                   boost::shared_ptr<DungeonMap> &dungeon_map,
                                   std::vector<boost::shared_ptr<Quest> > &quests,
                                   HomeManager &home_manager,
                                   std::vector<boost::shared_ptr<Player> > &players,
                                   StuffManager &stuff_manager,
                                   GoreManager &gore_manager,
                                   MonsterManager &monster_manager,
                                   EventManager &event_manager,
                                   bool &premapped,
                                   std::vector<std::pair<const ItemType *, std::vector<int> > > &starting_gears,
                                   TaskManager &task_manager,
                                   int house_col_0,
                                   int house_col_1) const
{
    pimpl->initializeGame(msel,
                          dungeon_map,
                          quests,
                          home_manager,
                          players,
                          stuff_manager,
                          gore_manager,
                          monster_manager,
                          event_manager,
                          premapped,
                          starting_gears,
                          task_manager,
                          house_col_0,
                          house_col_1);
}

boost::shared_ptr<const ConfigMap> KnightsConfig::getConfigMap() const
{
    return pimpl->getConfigMap();
}
