/*
 * knight_task.hpp
 *
 * This task reads controller inputs from the DungeonView and forwards
 * them to the player's knight. It also handles the calling of
 * Player::computeAvailableControls at regular intervals.
 *
 * (KnightTask can really be thought of as part of Player. In fact the
 * two files could probably be merged.)
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef KNIGHT_TASK_HPP
#define KNIGHT_TASK_HPP

#include "task.hpp"

#include "boost/shared_ptr.hpp"

class Knight;
class Player;

class KnightTask : public Task {
public:
    KnightTask(Player &p) : player(p), stored_control(0), xbow_load_time(0), xbow_action_timer(0) { }
    virtual void execute(TaskManager &);

private:
    void doControls(shared_ptr<Knight>);
    
    Player &player;
    const Control *stored_control;
    int xbow_load_time;
    int xbow_action_timer;
};

#endif
