/*
 * item_respawn_task.hpp
 *
 * Task that respawns items randomly after the game has been running for a while.
 *
 * Note that one important function of the item respawning is to put down extra
 * lockpicks. If all keys and lockpicks were placed behind locked doors, then
 * this will (eventually) place extra lockpicks somewhere where the players
 * can reach them.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 * 
 */

#ifndef ITEM_RESPAWN_TASK_HPP
#define ITEM_RESPAWN_TASK_HPP

#include "task.hpp"

#include "boost/shared_ptr.hpp"
using namespace boost;

class ItemGenerator;
class ItemType;

class ItemRespawnTask : public Task
{
public:
    ItemRespawnTask(const ItemGenerator *item_gen_,
                    const ItemType *lockpicks_,
                    int interval_,
                    int time_base_,
                    int odds_);

    virtual void execute(TaskManager &tm);

private:
    int countLockpicks() const;
    
    const ItemGenerator *item_gen;
    const ItemType *lockpicks;
    int interval;
    int time_base;
    int odds;
};

#endif
