/*
 * item_generator.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef ITEM_GENERATOR_HPP
#define ITEM_GENERATOR_HPP

#include "kconfig_fwd.hpp"
using namespace KConfig;

#include <vector>
using namespace std;

class ItemType;

//
// ItemGenerator generates an ItemType at random from a predetermined list.
// (It's very similar to RandomAction. Perhaps there should be some sort of template 
// class RandomList<T>.)
//
class ItemGenerator {
public:
    ItemGenerator() : total_weight(0), fixed_item_type(0), amount(0) { }

    // add "fixed item"
    // amount==NULL is treated as amount==RIConstant(1).
    void setFixedItemType(const ItemType *i, const RandomInt * n)
        { fixed_item_type = i; amount = n; }

    // add "child generators"
    void reserve(int n) { data.reserve(n); }
    void add(const ItemGenerator *ig, int wt);

    // If a fixed item type is set, then get() will return that.
    // Otherwise, one of the child item generators will be invoked.    
    pair<const ItemType *, int> get() const;
    
private:
    vector<pair<const ItemGenerator *, int> > data;
    int total_weight;
    const ItemType *fixed_item_type;
    const RandomInt * amount;
};

#endif
