/*
 * item_generator.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "item_generator.hpp"
#include "rng.hpp"

#include "random_int.hpp"
using namespace KConfig;

void ItemGenerator::add(const ItemGenerator *ig, int wt)
{
    if (ig && wt > 0) {
        data.push_back(make_pair(ig, wt));
        total_weight += wt;
    }
}

pair<const ItemType *, int> ItemGenerator::get() const
{
    if (fixed_item_type) {
        int n = 1;
        if (amount) n = amount->get();
        return make_pair(fixed_item_type,n);
    } else if (total_weight > 0) {
        int r = g_rng.getInt(0, total_weight);
        for (int i=0; i<data.size(); ++i) {
            r -= data[i].second;
            if (r < 0) return data[i].first->get();
        }
        ASSERT(0);
    }
    return pair<const ItemType *, int>(0,0);
}


