/*
 * home_manager.hpp
 *
 * Handles Wands of Securing.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef HOME_MANAGER_HPP
#define HOME_MANAGER_HPP

#include "map_support.hpp"

#include <map>
using namespace std;

class Player;
class Tile;

class HomeManager {
public:
    // setup -- All homes in the dungeon must be added.
    // The pos is the tile one outside the home, and the facing must point towards
    // the home.
    // NOTE: we assume all homes are in the same DungeonMap at present. 
    void addHome(const MapCoord &pos, MapDirection facing);

    // Secure a home by a given player
    // (This does nothing if the given tile is not a home.)
    void secureHome(const Player &pl,
                    DungeonMap &dmap, const MapCoord &pos, MapDirection facing,
                    shared_ptr<Tile> secured_wall_tile);

private:
    // returns a null MapCoord if no such home can be found
    pair<MapCoord,MapDirection> getRandomHomeFor(const Player &pl) const;
    
private:
    // This map stores the secure-status of each home.
    // stored player == 0 means the home is unsecured
    // stored player != 0 means the home is secured by that player
    // Home not in map at all == The home was secured by both players.
    // NOTE: We assume all homes are in the same DungeonMap at present. 
    typedef map<pair<MapCoord,MapDirection>, const Player *> HomeMap;
    HomeMap homes;
};

#endif
