/*
 * healing_task.hpp
 *
 * HealingTask is a Task that adds a certain amount to a creature's
 * health at regular intervals. It's used both by homes (in
 * Player::onMove) and by regeneration potions.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef HEALING_TASK_HPP
#define HEALING_TASK_HPP

#include "task.hpp"

class Creature;

class HealingTask : public Task {
public:
    HealingTask(weak_ptr<Creature> c, int dt, int ha) : creature(c), time_interval(dt),
                                                        healing_amount(ha) { }
    virtual void execute(TaskManager &);

protected:
    shared_ptr<Creature> getCreature() const { return creature.lock(); }

private:
    weak_ptr<Creature> creature;
    int time_interval, healing_amount;
};

#endif

