/*
 * healing_task.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "healing_task.hpp"
#include "creature.hpp"
#include "task_manager.hpp"

void HealingTask::execute(TaskManager &tm)
{
    shared_ptr<Creature> cr(creature.lock());
    if (cr && cr->getMap()) {
        cr->addToHealth(healing_amount);
        int gvt = tm.getGVT();
        tm.addTask(shared_from_this(), TP_NORMAL, gvt + time_interval);
    }
}
