/*
 * event_manager.hpp
 *
 * Processes "script events". Usually called via Mediator.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef EVENT_MANAGER_HPP
#define EVENT_MANAGER_HPP

#include "map_support.hpp"

#include <map>
#include <string>
using namespace std;

class Action;
class ActionData;
class Creature;
class DungeonMap;
class Tile;

class EventManager {
public:
    static void onAddCreature(Creature &);                          // on_walk_over
    static void onRmCreature(Creature &);                           // on_withdraw 
    static void postRepositionCreature(Creature &);                 // on_walk_over
    static void onChangeEntityMotion(Creature &);                   // on_approach, on_withdraw
    static void onAddTile(DungeonMap &, const MapCoord &, Tile &);  // on_walk_over
    static void onRmTile(DungeonMap &, const MapCoord &, Tile &);   // on_withdraw

    // A generic system for "event hooks"
    void setupHooks(const map<string, const Action*> &h) { hooks = h; }
    void runHook(const string &h, shared_ptr<Creature> cr) const;
    void runHook(const string &h, DungeonMap *dmap, const MapCoord &mc) const;
    
private:
    static void walkOverEvent(Creature &);
    static void withdrawEvent(Creature &);

    void doHook(const string &name, const ActionData &ad) const;

    map<string, const Action*> hooks;
};

#endif
