/*
 * dungeon_layout.hpp
 *
 * A DungeonLayout gives the layout for a Knights-style dungeon.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef DUNGEON_LAYOUT_HPP
#define DUNGEON_LAYOUT_HPP

#include <vector>
using namespace std;

enum BlockType {
    BT_NONE, BT_BLOCK, BT_EDGE, BT_SPECIAL, NUM_BLOCK_TYPES
};

class DungeonLayout {
public:
    DungeonLayout(int w, int h);
    void setBlockType(int x, int y, BlockType bt);

    // specify whether exits can be created between adjacent blocks.
    // for vert exits,  x ranges from 0 to w-1, y ranges from 0 to h-2.
    // for horiz exits, x ranges from 0 to w-2, y ranges from 0 to h-1.
    void setHorizExit(int x, int y, bool have_exit);
    void setVertExit(int x, int y, bool have_exit);
    
    // accessors
    int getWidth() const { return width; }
    int getHeight() const { return height; }
    BlockType getBlockType(int x, int y) const;
    bool hasHorizExit(int x, int y) const;
    bool hasVertExit(int x, int y) const;

private:
    int width, height;
    vector<BlockType> data;
    vector<bool> horiz_exits;
    vector<bool> vert_exits;
};

class RandomDungeonLayout {
public:
    void add(const DungeonLayout * d) { if (d) data.push_back(d); }
    const DungeonLayout * choose() const;  // picks one of the layouts at random.
private:
    vector<const DungeonLayout *> data;
};

#endif
