/*
 * dungeon_layout.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "dungeon_layout.hpp"
#include "rng.hpp"

DungeonLayout::DungeonLayout(int w, int h)
    : width(w), height(h), data(w*h), horiz_exits((w-1)*h), vert_exits(w*(h-1))
{ }

void DungeonLayout::setBlockType(int x, int y, BlockType bt)
{
    if (x < 0 || x >= width || y < 0 || y >= height) return;
    data[y*width+x] = bt;
}

void DungeonLayout::setVertExit(int x, int y, bool have_exit)
{
    if (x < 0 || x >= width || y < 0 || y >= (height-1)) return;
    vert_exits[y*width+x] = have_exit;
}

void DungeonLayout::setHorizExit(int x, int y, bool have_exit)
{
    if (x < 0 || x >= (width-1) || y < 0 || y >= height) return;
    horiz_exits[y*(width-1)+x] = have_exit;
}

BlockType DungeonLayout::getBlockType(int x, int y) const
{
    if (x < 0 || x >= width || y < 0 || y >= height) return BT_BLOCK;
    return data[y*width+x];
}

bool DungeonLayout::hasVertExit(int x, int y) const
{
    if (x < 0 || x >= width || y < 0 || y >= (height-1)) return false;
    return vert_exits[y*width + x];
}

bool DungeonLayout::hasHorizExit(int x, int y) const
{
    if (x < 0 || x >= (width-1) || y < 0 || y >= height) return false;
    return horiz_exits[y*(width-1) + x];
}


const DungeonLayout * RandomDungeonLayout::choose() const
{
    int i = g_rng.getInt(0, data.size());
    return data[i];
}
