/*
 * dummy_callbacks.hpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef DUMMY_CALLBACKS_HPP
#define DUMMY_CALLBACKS_HPP

#include "dungeon_view.hpp"
#include "mini_map.hpp"
#include "status_display.hpp"
#include "knights_callbacks.hpp"

class DummyDungeonView : public DungeonView {
public:
    virtual void setCurrentRoom(int,int,int) { }
    virtual void addEntity(unsigned short int, int, int, MapHeight, MapDirection,
                           const Anim *, const Overlay *, int, int, bool, int, MotionType, int) { }
    virtual void rmEntity(unsigned short int) { }
    virtual void repositionEntity(unsigned short int, int, int) { }
    virtual void moveEntity(unsigned short int, MotionType, int, bool) { }
    virtual void flipEntityMotion(unsigned short int, int, int) { }
    virtual void setAnimData(unsigned short int, const Anim *, const Overlay *, int, int, bool, bool) { }
    virtual void setFacing(unsigned short int, MapDirection) { }
    virtual void clearTiles(int,int) { }
    virtual void setTile(int,int,int,const Graphic *, boost::shared_ptr<const ColourChange>) { }
    virtual void setItem(int, int, const Graphic *) { }
    virtual void placeIcon(int, int, const Graphic *, int) { }
    virtual void flashMessage(const std::string&, int) { }
    virtual void cancelContinuousMessages() { }
    virtual void addContinuousMessage(const std::string&) { }
};

class DummyMiniMap : public MiniMap {
public:
    virtual void setSize(int,int) { }
    virtual void setColour(int, int, MiniMapColour) { }
    virtual void wipeMap() { }
    virtual void mapKnightLocation(int,int,int) { }
    virtual void mapItemLocation(int,int,bool) { }
};

class DummyStatusDisplay : public StatusDisplay {
public:
    virtual void setBackpack(int, const Graphic *, const Graphic *, int, int) { }
    virtual void addSkull() { }
    virtual void setHealth(int) { }
    virtual void setPotionMagic(PotionMagic, bool) { }
    virtual void setQuestMessage(const std::string &) { }
    virtual void setQuestIcons(const std::vector<StatusDisplay::QuestIconInfo> &) { }
};

class DummyCallbacks : public KnightsCallbacks {
public:
    virtual DungeonView & getDungeonView(int) { return dummy_dungeon_view; }
    virtual MiniMap & getMiniMap(int) { return dummy_mini_map; }
    virtual StatusDisplay & getStatusDisplay(int) { return dummy_status_display; }
    virtual void playSound(int, const Sound&, int) { }
    virtual void winGame(int) { }
    virtual void loseGame(int) { }
    virtual void setAvailableControls(int, const std::vector<std::pair<const UserControl*,bool> >&) { }
    virtual void setMenuHighlight(int, const UserControl*) { }
    virtual void flashScreen(int,int) { }
private:
    DummyDungeonView dummy_dungeon_view;
    DummyMiniMap dummy_mini_map;
    DummyStatusDisplay dummy_status_display;
};

#endif
