/*
 * dispel_magic.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef DISPEL_MAGIC_HPP
#define DISPEL_MAGIC_HPP

#include "boost/shared_ptr.hpp"
using namespace boost;

#include <vector>
using namespace std;

class Knight;
class Player;

// This routine simply calls dispelMagic() on each Knight.
void DispelMagic(const vector<Player*> &);

// DispelObserver: class that gets notified when a dispel magic occurs
// (These are attached to Knights.)
class DispelObserver {
public:
    virtual ~DispelObserver() { }
    virtual void onDispel(shared_ptr<Knight> kt) = 0;
};

#endif
