/*
 * dispel_magic.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "dispel_magic.hpp"
#include "knight.hpp"
#include "player.hpp"

void DispelMagic(const vector<Player*> &players)
{
    for (vector<Player*>::const_iterator it = players.begin(); it != players.end(); ++it) {
        shared_ptr<Knight> kt = (*it)->getKnight();
        if (kt) {
            kt->dispelMagic();
        }
    }
}
