/*
 * create_quest.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "concrete_quests.hpp"
#include "create_quest.hpp"
#include "knights_config_impl.hpp"

#include "kfile.hpp"
using namespace KConfig;

using namespace boost;
using namespace std;

namespace {
    void PopItemList(KnightsConfigImpl &kc, vector<const ItemType *> &output)
    {
        output.clear();
        KFile::List lst(*kc.getKFile(), "list of items");
        for (int i=0; i<lst.getSize(); ++i) {
            lst.push(i);
            const ItemType *it = kc.popItemType();
            if (!it) kc.getKFile()->errExpected("item type");
            output.push_back(it);
        }
    }
}

shared_ptr<Quest> CreateQuest(const string &name, KnightsConfigImpl &kc)
{
    shared_ptr<Quest> result;
    if (name == "QuestRetrieve") {
        KFile::List lst(*kc.getKFile(), "", 3, 4);
        lst.push(0);
        int n = kc.getKFile()->popInt();
        lst.push(1);
        vector<const ItemType *> items;
        PopItemList(kc, items);
        lst.push(2);
        string sing = kc.getKFile()->popString();
        lst.push(3);
        string pl = kc.getKFile()->popString(sing + "S");
        result.reset(new QuestRetrieve(n, items, sing, pl));

    } else if (name == "QuestDestroy") {
        vector<const ItemType *> book, wand;
        KFile::List lst(*kc.getKFile(), "", 2);
        lst.push(0);
        PopItemList(kc, book);
        lst.push(1);
        PopItemList(kc, wand);
        result.reset(new QuestDestroy(book, wand));

    } else {
        kc.getKFile()->errExpected("MenuDirective");
    }

    return result;
}
