/*
 * control.hpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef CONTROL_HPP
#define CONTROL_HPP

#include "user_control.hpp"

#include <vector>
using namespace std;

class Action;

//
// 'Controls' represent something a knight can do.
// (eg move, activate, pick up item).
//

class Control : public UserControl {
public:
    Control(int id, const Graphic *menu_gfx, MapDirection menu_dir,
            int tap_pri, bool cts, unsigned int special,
            const Action *action_)
        : UserControl(id, menu_gfx, menu_dir, tap_pri, cts, special),
          action(action_)
    { }

    // action to run when the control is selected.
    const Action * getAction() const { return action; }

private:
    const Action *action;
};

#endif
