/*
 * concrete_traps.hpp
 *
 * Concrete Trap classes (poison darts and spring blade traps).
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef TRAPS_HPP
#define TRAPS_HPP

#include "map_support.hpp"
#include "trap.hpp"

class BladeTrap : public Trap {
public:
    BladeTrap(const ItemType *trap_item, const ItemType &missile_type,
              MapDirection fire_direction)
        : Trap(trap_item), mtype(missile_type), fire_dirn(fire_direction) { }
    virtual void spring(DungeonMap &, const MapCoord &, shared_ptr<Creature>);
    virtual bool activateOnHit() const { return true; }
private:
    const ItemType &mtype;
    MapDirection fire_dirn;
};

class PoisonTrap : public Trap {
public:
    explicit PoisonTrap(const ItemType *trap_item) : Trap(trap_item) { }
    virtual void spring(DungeonMap &, const MapCoord &, shared_ptr<Creature>);
    virtual bool activateOnHit() const { return false; }
};

#endif
