/*
 * concrete_traps.cpp
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "concrete_traps.hpp"
#include "creature.hpp"
#include "missile.hpp"

void BladeTrap::spring(DungeonMap &dmap, const MapCoord &mc, shared_ptr<Creature>)
{
    CreateMissile(dmap, mc, fire_dirn, mtype, false, false);
}

void PoisonTrap::spring(DungeonMap &, const MapCoord &, shared_ptr<Creature> cr)
{
    if (cr) cr->poison();
}

