/*
 * quests.hpp
 *
 * The concrete Quest classes.
 *
 * Copyright (c) Stephen Thompson, 2008.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef QUESTS_HPP
#define QUESTS_HPP

#include "quest.hpp"

#include <vector>
using namespace std;

class QuestRetrieve : public Quest {
public:
    // This checks whether the knight is holding (at least) the given number of the
    // given item type. (Any one of the item types on the list are acceptable.)
    QuestRetrieve(int n, const vector<const ItemType*> &i,
                  const string &sing, const string &pl)
        : no(n), itypes(i), singular(sing), plural(pl) { }
    virtual bool check(Knight &) const;
    virtual string getHint() const;
    virtual bool isItemInteresting(const ItemType &itype) const;
    virtual void appendQuestIcon(const Knight *kt, std::vector<StatusDisplay::QuestIconInfo> &icons) const;
private:
    int no;
    const vector<const ItemType*> itypes;
    string singular, plural;
};

class QuestDestroy : public Quest {
public:
    // This checks whether the knight is holding one of the given wands, and one of the given
    // books is in the square ahead. (This is intended to be called from "on_hit" on the
    // special pentagram tile.)
    QuestDestroy(const vector<const ItemType*> &book_,
                 const vector<const ItemType*> &wand_)
        : book(book_), wand(wand_) { }
    virtual bool check(Knight &) const;
    virtual bool isItemInteresting(const ItemType &itype) const;
    virtual void appendQuestIcon(const Knight *, std::vector<StatusDisplay::QuestIconInfo> &icons) const { }
    virtual std::string getQuestMessage() const { return "Destroy Book with Wand"; }
private:
    vector<const ItemType*> book;
    vector<const ItemType*> wand;
};

#endif
